*********************************************************************
******** CONFIDENCE IN AUSTRALIAN BANKANOTES - MAIN MODELS **********
********************* DATE: December 2019 ***************************
*************** AUTHORS: KIM NGUYEN AND ANNY FRANCIS ****************
*********************************************************************

/* Open cleaned data file */

use "finaldata.dta",clear
set more off

/* Tables */

//// Table 3: Demographics

quietly probit willgetcf gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m1
quietly probit cfproblem gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth  i.year, vce(robust)
estpost margins, dydx(*)
eststo m2
quietly probit confsystems gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m3
quietly probit willgetcf  gender i.agegroup1 i.incometier problemsusing i.cashdaily   i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year if hadacf==1, vce(robust)
estpost margins, dydx(*)
eststo m4
quietly probit willgetcf  gender i.agegroup1 i.incometier problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year if hadacf==0, vce(robust)
estpost margins, dydx(*)
eststo m5
quietly probit hadacf gender i.agegroup1 i.incometier problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth  i.year, vce(robust)
estpost margins, dydx(*)
eststo m6
esttab m1 m2 m3 m4 m5 m6 using "demographics.csv", se margin title(Demographics Regressions) star(* 0.10 ** 0.05 *** 0.01)  replace 
eststo clear 



//// Table 4: Experiences with counterfeits

quietly probit willgetcf hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m1
quietly probit cfproblem hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth  i.year, vce(robust)
estpost margins, dydx(*)
eststo m2
quietly probit confsystems hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m3
esttab m1 m2 m3 using "experiences_counterfeit.csv", se margin title(Experiences with Counterfeits Regressions) star(* 0.10 ** 0.05 *** 0.01)  replace 
eststo clear 



//// Table 5: Experiences with counterfeits - 2017 and 2019 surveys

quietly probit willgetcf i.hadacf_17 i.problem_nns  i.problem_ngb  i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier i.state area i.household i.employment  i.countryofbirth i.year if year>=4, vce(robust)
estpost margins, dydx(*)
eststo m1
quietly probit cfproblem i.hadacf_17 i.problem_nns  i.problem_ngb  i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year if year>=4, vce(robust)
estpost margins, dydx(*)
eststo m2
quietly probit confsystems i.hadacf_17 i.problem_nns  i.problem_ngb  i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year if year>=4, vce(robust)
estpost margins, dydx(*)
eststo m3
esttab m1 m2 m3 using "experiences_1719_all.csv", se margin title(Experiences with Counterfeits Regressions - 2017 and 2019) star(* 0.10 ** 0.05 *** 0.01)  replace 
eststo clear 



//// Table 6: Problems with using banknotes

quietly probit willgetcf hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m1
quietly probit cfproblem hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth  i.year, vce(robust)
estpost margins, dydx(*)
eststo m2
quietly probit confsystems hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m3
quietly probit willgetcf  problemsusing i.cashdaily   i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year if hadacf==1, vce(robust)
estpost margins, dydx(*)
eststo m4
quietly probit willgetcf  problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year if hadacf==0, vce(robust)
estpost margins, dydx(*)
eststo m5
quietly probit hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq   gender i.agegroup1 i.incometier i.state area i.household i.employment  i.countryofbirth  i.year, vce(robust)
estpost margins, dydx(*)
eststo m6
esttab m1 m2 m3 m4 m5 m6 using "experiences_problems.csv", se margin title(Experiences using Banknotes Regressions) star(* 0.10 ** 0.05 *** 0.01)  replace 
eststo clear 



//// Table 7: Problems with using banknotes - 2017 and 2019 surveys

quietly probit willgetcf i.hadacf_17  i.problem_nns  i.problem_ngb  i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier i.state area i.household i.employment  i.countryofbirth i.year if year>=4, vce(robust)
estpost margins, dydx(*)
eststo m1
quietly probit cfproblem i.hadacf_17  i.problem_nns  i.problem_ngb i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year if year>=4, vce(robust)
estpost margins, dydx(*)
eststo m2
quietly probit confsystems i.hadacf_17  i.problem_nns  i.problem_ngb  i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year if year>=4, vce(robust)
estpost margins, dydx(*)
eststo m3
quietly probit confsystems  i.problem_nns  i.problem_ngb i.cashdaily   i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year if hadacf_17>0 & year>=4, vce(robust)
estpost margins, dydx(*)
eststo m4
quietly probit confsystems  i.problem_nns  i.problem_ngb i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year if hadacf_17==0 & year>=4, vce(robust)
estpost margins, dydx(*)
eststo m5
quietly probit hadacf  i.problem_nns  i.problem_ngb i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier i.state area i.household i.employment  i.countryofbirth  i.year if year>=4, vce(robust)
estpost margins, dydx(*)
eststo m6
esttab m1 m2 m3 m4 m5 m6 using "experiences_1719_serious.csv", se margin title(Experiences using Banknotes Regressions - 2017 and 2019) star(* 0.10 ** 0.05 *** 0.01)  replace 
eststo clear 



//// Table 8: Awareness of NGB and of security features 

quietly probit willgetcf hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m1
quietly probit cfproblem hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth  i.year, vce(robust)
estpost margins, dydx(*)
eststo m2
quietly probit confsystems hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m3
quietly probit willgetcf  problemsusing i.cashdaily   i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year if hadacf==1, vce(robust)
estpost margins, dydx(*)
eststo m4
quietly probit willgetcf  problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq  gender i.agegroup1 i.incometier   i.state area i.household i.employment  i.countryofbirth i.year if hadacf==0, vce(robust)
estpost margins, dydx(*)
eststo m5
quietly probit hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq   gender i.agegroup1 i.incometier i.state area i.household i.employment  i.countryofbirth  i.year, vce(robust)
estpost margins, dydx(*)
eststo m6
esttab m1 m2 m3 m4 m5 m6 using "experiences_awareness.csv", se margin title(Awareness Regressions) star(* 0.10 ** 0.05 *** 0.01)  replace 
eststo clear 


//// Table 9: Media reports on counterfeits - The data are not available for release due to confidentiality reason

use "genuine_media.dta", clear //

quietly eststo m1: reg genuine narticles lag1na incidents lag1incidents logcf bnquality pop cpi employ hours i.month_year, robust
quietly eststo m2: reg genuine narticles lag1na incidents lag1incidents logcf bnquality pop cpi employ hours i.stateid, robust
quietly eststo m3: reg genuine narticles lag1na incidents lag1incidents logcf bnquality pop cpi employ hours i.month_year i.stateid, robust
esttab m1 m2 m3 using "media_regressions.csv", se margin title(Media Regressions) star(* 0.10 ** 0.05 *** 0.01) replace 
eststo clear 

//// Equivalent codes

xtset stateid month_year
xi: xtreg genuine narticles lag1na incidents lag1incidents logcf bnquality pop cpi employ hours i.month_year, re robust
xi: xtreg genuine narticles lag1na incidents lag1incidents logcf bnquality pop cpi employ hours, fe robust
xi: xtreg genuine narticles lag1na incidents lag1incidents logcf bnquality pop cpi employ hours i.month_year, fe robust


